function u = update_tumor_pde_pressure(u, D, K, p, dt, dx)
%UPDATE_TUMOR_PDE_PRESSURE
% Aggiorna la densita'  tumorale u secondo diffusione con pressione
% (upwind scheme) e crescita logistica.
%
% u  : densita'  tumorale (Nx+1 x 1)
% D  : coefficiente di diffusione
% K  : capacita'  portante
% p  : tasso di proliferazione
% dt : passo temporale
% dx : passo spaziale

Nx = length(u) - 1;

% Calcolo flussi (upwind per la pressione)
u_destra   = [u(2:end); 0];
u_sinistra = [0; u(1:end-1)];

% Flusso con upwind: diffusione modulata dalla densita' 
Fu = -D * (u_destra - u) / dx;

% Aggiornamento tramite divergenza dei flussi
u = u + (dt/dx) * ([0; Fu(1:Nx)] - [Fu(1:Nx); 0]);

% Reazione: crescita logistica sotto pressione
rho = u;
u = u + dt * (p * (1 - rho./K) .* u);

% Condizioni al bordo di Neumann (no-flux)
u(1)     = u(2);
u(end)   = u(end-1);

end
